import math

def istPZ (n):
    p=True
    if (n % 2 == 0):
        return False
    t=3
    while (p and (t < math.sqrt(n) )):
           if (n % t == 0): p=False
           t=t+2
    return p

def pot(b,e,m):
    p=1
    while (e>0):
        p = p*b % m
        e=e-1
    return p

def potmod(b,e,m):
    p=1
    ex = e
    ba = b
    while (ex>0):
        if ex % 2 == 1:
            p = (p*ba) % m
            ex=ex-1
        ex = ex // 2
        ba = (ba * ba) % m           
    return p

def ggT(a,b):
    if a<b :
        c=b
        d=a
    else:
        c = a
        d = b
        
    while ( d != 0 ):
        r= c % d
        c=d
        d=r
    return c

def sucheEntschExpo (ee,nm):
    i=1
    while ((i<nm) and ((i*ee) % nm != 1)): i=i+1
    if (i < nm): return i
    else: return -1

def inverseBestimmen (z, mo):
    inv =0
    if ggT (mo,z) == 1:
        
        a= mo
        b = z
        az=0
        amo=1
        bz=1
        bmo=0
        while (b != 1):
            q = a / b
            r = a % b
            
            altaz = az
            altamo = amo
            az = bz
            amo = bmo
            bz = altaz - q * az
            bmo = altamo - q * amo
            
            a = b
            b = r
        inv = bz
        
        if (inv < 0): inv = inv + mo
        
    return inv


""" Eingabebereich
1. Test 97987 und 97973 mit e= 37141
Mersenne-PZ 24036583  25964951
"""
pz1=24036583
pz2=25964951
e= 37141
m = 654567

print "RSA - Test" 
print "============================="
print repr(pz1) + ' Primzahl?  ->' + repr(istPZ(pz1))
print repr(pz2) + ' Primzahl?  ->' + repr(istPZ(pz2))
nn=pz1*pz2
print 'n = p*q = ' + repr(nn)
nebenmodul=(pz1-1)*(pz2-1)
print 'Nebenmodul = (p-1)*(q-1) = '+ repr(nebenmodul)
print 'Verschlsselungsexponent e =' + repr(e)
if ggT(e,nebenmodul) == 1: print "ist geeignet"
else: print "ist nicht geeignet"

d = inverseBestimmen(e, nebenmodul)
print 'Entschlsselungsexponent '+ repr(d)

print 'AusgangsZahl= ' + repr(m)
c = potmod (m, e, nn)
print 'Chiffre= ' + repr(c)
mneu = potmod (c, d, nn)
print 'Entschlsselt= ' + repr(mneu)


